/*
 * Decompiled with CFR 0.152.
 */
package luckercracker.argentoz.hytale.auth.patcher;

import com.hypixel.hytale.plugin.early.ClassTransformer;
import com.hypixel.hytale.server.core.io.handlers.login.HandshakeHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import luckercracker.argentoz.org.objectweb.asm.ClassReader;
import luckercracker.argentoz.org.objectweb.asm.ClassWriter;
import luckercracker.argentoz.org.objectweb.asm.tree.ClassNode;
import luckercracker.argentoz.org.objectweb.asm.tree.FieldInsnNode;
import luckercracker.argentoz.org.objectweb.asm.tree.IincInsnNode;
import luckercracker.argentoz.org.objectweb.asm.tree.InsnList;
import luckercracker.argentoz.org.objectweb.asm.tree.InsnNode;
import luckercracker.argentoz.org.objectweb.asm.tree.IntInsnNode;
import luckercracker.argentoz.org.objectweb.asm.tree.JumpInsnNode;
import luckercracker.argentoz.org.objectweb.asm.tree.LabelNode;
import luckercracker.argentoz.org.objectweb.asm.tree.LdcInsnNode;
import luckercracker.argentoz.org.objectweb.asm.tree.MethodInsnNode;
import luckercracker.argentoz.org.objectweb.asm.tree.MethodNode;
import luckercracker.argentoz.org.objectweb.asm.tree.TryCatchBlockNode;
import luckercracker.argentoz.org.objectweb.asm.tree.TypeInsnNode;
import luckercracker.argentoz.org.objectweb.asm.tree.VarInsnNode;

public final class AuthTransformer
implements ClassTransformer {
    private static final String HANDSHAKE_HANDLER_INTERNAL = "com/hypixel/hytale/server/core/io/handlers/login/HandshakeHandler";
    private static final String REGISTERED0_NAME = "registered0";
    private static final String REGISTERED0_DESC = "(Lcom/hypixel/hytale/server/core/io/PacketHandler;)V";
    private static final String AUTHENTICATED_USERNAME_NAME = "authenticatedUsername";
    private static final String AUTHENTICATED_USERNAME_DESC = "Ljava/lang/String;";
    private static final String STRING_DESC = "Ljava/lang/String;";
    private static final String UUID_DESC = "Ljava/util/UUID;";
    private static final String COMPLETE_AUTH_NAME = "completeAuthentication";
    private static final String COMPLETE_AUTH_DESC = "([B)V";
    private static final String PASSWORD_CHALLENGE_NAME = "generatePasswordChallengeIfNeeded";
    private static final String PASSWORD_CHALLENGE_DESC = "()[B";
    private static final String GENERATE_NAME = "authPatch$generate";
    private static final String GENERATE_DESC = "(Ljava/lang/String;)Ljava/lang/String;";
    private static final String MD5_NAME = "authPatch$md5";
    private static final String MD5_DESC = "(Ljava/lang/String;)[B";
    private static final String DOTNET_GUID_NAME = "authPatch$toDotNetGuidByteOrder";
    private static final String DOTNET_GUID_DESC = "([B)[B";
    private static final String SWAP_NAME = "authPatch$swap";
    private static final String SWAP_DESC = "([BII)V";
    private static final String HANDSHAKE_HANDLER_CLASS_NAME = HandshakeHandler.class.getName();

    public byte[] transform(@Nonnull String name, @Nonnull String path, @Nonnull byte[] bytes) {
        if (!name.equals(HANDSHAKE_HANDLER_CLASS_NAME)) {
            return bytes;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept(node, 8);
        AuthTransformer.addGeneratorMethods(node);
        AuthTransformer.patchRegistered0(node);
        ClassWriter writer = new ClassWriter(this, 3){
            {
                Objects.requireNonNull(this$0);
                super(arg0);
            }

            @Override
            protected String getCommonSuperClass(String type1, String type2) {
                ClassLoader loader = AuthTransformer.class.getClassLoader();
                try {
                    Class<?> current;
                    Class<?> class1 = Class.forName(type1.replace('/', '.'), false, loader);
                    Class<?> class2 = Class.forName(type2.replace('/', '.'), false, loader);
                    if (class1.isAssignableFrom(class2)) {
                        return type1;
                    }
                    if (class2.isAssignableFrom(class1)) {
                        return type2;
                    }
                    if (class1.isInterface() || class2.isInterface()) {
                        return "java/lang/Object";
                    }
                    for (current = class1; current != null && !current.isAssignableFrom(class2); current = current.getSuperclass()) {
                    }
                    return current == null ? "java/lang/Object" : current.getName().replace('.', '/');
                }
                catch (Throwable ignored) {
                    return "java/lang/Object";
                }
            }
        };
        node.accept(writer);
        return writer.toByteArray();
    }

    private static void patchRegistered0(ClassNode node) {
        MethodNode method = null;
        for (MethodNode candidate : node.methods) {
            if (!REGISTERED0_NAME.equals(candidate.name) || !REGISTERED0_DESC.equals(candidate.desc)) continue;
            method = candidate;
        }
        if (method == null) {
            return;
        }
        InsnList injected = AuthTransformer.buildRegistered0Guard();
        method.instructions.insert(injected);
    }

    private static InsnList buildRegistered0Guard() {
        InsnList injected = new InsnList();
        LabelNode authLabel = new LabelNode();
        LabelNode continueLabel = new LabelNode();
        injected.add(new MethodInsnNode(184, "com/hypixel/hytale/server/core/auth/ServerAuthManager", "getInstance", "()Lcom/hypixel/hytale/server/core/auth/ServerAuthManager;", false));
        injected.add(new VarInsnNode(58, 1));
        injected.add(new VarInsnNode(25, 1));
        injected.add(new MethodInsnNode(182, "com/hypixel/hytale/server/core/auth/ServerAuthManager", "isSingleplayer", "()Z", false));
        injected.add(new JumpInsnNode(154, authLabel));
        injected.add(new VarInsnNode(25, 1));
        injected.add(new MethodInsnNode(182, "com/hypixel/hytale/server/core/auth/ServerAuthManager", "getAuthMode", "()Lcom/hypixel/hytale/server/core/auth/ServerAuthManager$AuthMode;", false));
        injected.add(new FieldInsnNode(178, "com/hypixel/hytale/server/core/auth/ServerAuthManager$AuthMode", "NONE", "Lcom/hypixel/hytale/server/core/auth/ServerAuthManager$AuthMode;"));
        injected.add(new JumpInsnNode(165, authLabel));
        injected.add(new VarInsnNode(25, 0));
        injected.add(new FieldInsnNode(180, HANDSHAKE_HANDLER_INTERNAL, "username", "Ljava/lang/String;"));
        injected.add(new MethodInsnNode(184, HANDSHAKE_HANDLER_INTERNAL, GENERATE_NAME, GENERATE_DESC, false));
        injected.add(new MethodInsnNode(184, "java/util/UUID", "fromString", "(Ljava/lang/String;)Ljava/util/UUID;", false));
        injected.add(new VarInsnNode(25, 0));
        injected.add(new FieldInsnNode(180, HANDSHAKE_HANDLER_INTERNAL, "playerUuid", UUID_DESC));
        injected.add(new MethodInsnNode(182, "java/util/UUID", "equals", "(Ljava/lang/Object;)Z", false));
        injected.add(new JumpInsnNode(153, continueLabel));
        injected.add(authLabel);
        injected.add(new VarInsnNode(25, 0));
        injected.add(new VarInsnNode(25, 0));
        injected.add(new FieldInsnNode(180, HANDSHAKE_HANDLER_INTERNAL, "username", "Ljava/lang/String;"));
        injected.add(new FieldInsnNode(181, HANDSHAKE_HANDLER_INTERNAL, AUTHENTICATED_USERNAME_NAME, "Ljava/lang/String;"));
        injected.add(new VarInsnNode(25, 0));
        injected.add(new VarInsnNode(25, 0));
        injected.add(new MethodInsnNode(182, HANDSHAKE_HANDLER_INTERNAL, PASSWORD_CHALLENGE_NAME, PASSWORD_CHALLENGE_DESC, false));
        injected.add(new MethodInsnNode(182, HANDSHAKE_HANDLER_INTERNAL, COMPLETE_AUTH_NAME, COMPLETE_AUTH_DESC, false));
        injected.add(new InsnNode(177));
        injected.add(continueLabel);
        return injected;
    }

    private static void addGeneratorMethods(ClassNode node) {
        if (!AuthTransformer.hasMethod(node, MD5_NAME, MD5_DESC)) {
            node.methods.add(AuthTransformer.buildMd5Method());
        }
        if (!AuthTransformer.hasMethod(node, SWAP_NAME, SWAP_DESC)) {
            node.methods.add(AuthTransformer.buildSwapMethod());
        }
        if (!AuthTransformer.hasMethod(node, DOTNET_GUID_NAME, DOTNET_GUID_DESC)) {
            node.methods.add(AuthTransformer.buildDotNetGuidMethod());
        }
        if (!AuthTransformer.hasMethod(node, GENERATE_NAME, GENERATE_DESC)) {
            node.methods.add(AuthTransformer.buildGenerateMethod());
        }
    }

    private static boolean hasMethod(ClassNode node, String name, String desc) {
        for (MethodNode candidate : node.methods) {
            if (!name.equals(candidate.name) || !desc.equals(candidate.desc)) continue;
            return true;
        }
        return false;
    }

    private static MethodNode buildGenerateMethod() {
        MethodNode method = new MethodNode(10, GENERATE_NAME, GENERATE_DESC, null, null);
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new MethodInsnNode(184, HANDSHAKE_HANDLER_INTERNAL, MD5_NAME, MD5_DESC, false));
        method.instructions.add(new VarInsnNode(58, 1));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new IntInsnNode(16, 6));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new IntInsnNode(16, 6));
        method.instructions.add(new InsnNode(51));
        method.instructions.add(new IntInsnNode(16, 15));
        method.instructions.add(new InsnNode(126));
        method.instructions.add(new IntInsnNode(16, 48));
        method.instructions.add(new InsnNode(128));
        method.instructions.add(new InsnNode(145));
        method.instructions.add(new InsnNode(84));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new IntInsnNode(16, 8));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new IntInsnNode(16, 8));
        method.instructions.add(new InsnNode(51));
        method.instructions.add(new IntInsnNode(16, 63));
        method.instructions.add(new InsnNode(126));
        method.instructions.add(new IntInsnNode(16, 128));
        method.instructions.add(new InsnNode(128));
        method.instructions.add(new InsnNode(145));
        method.instructions.add(new InsnNode(84));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new MethodInsnNode(184, HANDSHAKE_HANDLER_INTERNAL, DOTNET_GUID_NAME, DOTNET_GUID_DESC, false));
        method.instructions.add(new VarInsnNode(58, 2));
        method.instructions.add(new InsnNode(9));
        method.instructions.add(new VarInsnNode(55, 3));
        method.instructions.add(new InsnNode(9));
        method.instructions.add(new VarInsnNode(55, 5));
        method.instructions.add(new InsnNode(3));
        method.instructions.add(new VarInsnNode(54, 7));
        LabelNode loopStartMsb = new LabelNode();
        LabelNode loopEndMsb = new LabelNode();
        method.instructions.add(loopStartMsb);
        method.instructions.add(new VarInsnNode(21, 7));
        method.instructions.add(new IntInsnNode(16, 8));
        method.instructions.add(new JumpInsnNode(162, loopEndMsb));
        method.instructions.add(new VarInsnNode(22, 3));
        method.instructions.add(new IntInsnNode(16, 8));
        method.instructions.add(new InsnNode(121));
        method.instructions.add(new VarInsnNode(25, 2));
        method.instructions.add(new VarInsnNode(21, 7));
        method.instructions.add(new InsnNode(51));
        method.instructions.add(new InsnNode(133));
        method.instructions.add(new LdcInsnNode(255L));
        method.instructions.add(new InsnNode(127));
        method.instructions.add(new InsnNode(129));
        method.instructions.add(new VarInsnNode(55, 3));
        method.instructions.add(new IincInsnNode(7, 1));
        method.instructions.add(new JumpInsnNode(167, loopStartMsb));
        method.instructions.add(loopEndMsb);
        method.instructions.add(new IntInsnNode(16, 8));
        method.instructions.add(new VarInsnNode(54, 7));
        LabelNode loopStartLsb = new LabelNode();
        LabelNode loopEndLsb = new LabelNode();
        method.instructions.add(loopStartLsb);
        method.instructions.add(new VarInsnNode(21, 7));
        method.instructions.add(new IntInsnNode(16, 16));
        method.instructions.add(new JumpInsnNode(162, loopEndLsb));
        method.instructions.add(new VarInsnNode(22, 5));
        method.instructions.add(new IntInsnNode(16, 8));
        method.instructions.add(new InsnNode(121));
        method.instructions.add(new VarInsnNode(25, 2));
        method.instructions.add(new VarInsnNode(21, 7));
        method.instructions.add(new InsnNode(51));
        method.instructions.add(new InsnNode(133));
        method.instructions.add(new LdcInsnNode(255L));
        method.instructions.add(new InsnNode(127));
        method.instructions.add(new InsnNode(129));
        method.instructions.add(new VarInsnNode(55, 5));
        method.instructions.add(new IincInsnNode(7, 1));
        method.instructions.add(new JumpInsnNode(167, loopStartLsb));
        method.instructions.add(loopEndLsb);
        method.instructions.add(new TypeInsnNode(187, "java/util/UUID"));
        method.instructions.add(new InsnNode(89));
        method.instructions.add(new VarInsnNode(22, 3));
        method.instructions.add(new VarInsnNode(22, 5));
        method.instructions.add(new MethodInsnNode(183, "java/util/UUID", "<init>", "(JJ)V", false));
        method.instructions.add(new MethodInsnNode(182, "java/util/UUID", "toString", "()Ljava/lang/String;", false));
        method.instructions.add(new InsnNode(176));
        return method;
    }

    private static MethodNode buildMd5Method() {
        MethodNode method = new MethodNode(10, MD5_NAME, MD5_DESC, null, null);
        LabelNode start = new LabelNode();
        LabelNode end = new LabelNode();
        LabelNode handler = new LabelNode();
        method.tryCatchBlocks.add(new TryCatchBlockNode(start, end, handler, "java/security/NoSuchAlgorithmException"));
        method.instructions.add(start);
        method.instructions.add(new LdcInsnNode("MD5"));
        method.instructions.add(new MethodInsnNode(184, "java/security/MessageDigest", "getInstance", "(Ljava/lang/String;)Ljava/security/MessageDigest;", false));
        method.instructions.add(new VarInsnNode(58, 1));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new FieldInsnNode(178, "java/nio/charset/StandardCharsets", "UTF_8", "Ljava/nio/charset/Charset;"));
        method.instructions.add(new MethodInsnNode(182, "java/lang/String", "getBytes", "(Ljava/nio/charset/Charset;)[B", false));
        method.instructions.add(new MethodInsnNode(182, "java/security/MessageDigest", "digest", DOTNET_GUID_DESC, false));
        method.instructions.add(new InsnNode(176));
        method.instructions.add(end);
        method.instructions.add(handler);
        method.instructions.add(new VarInsnNode(58, 2));
        method.instructions.add(new TypeInsnNode(187, "java/lang/RuntimeException"));
        method.instructions.add(new InsnNode(89));
        method.instructions.add(new LdcInsnNode("MD5 not available"));
        method.instructions.add(new VarInsnNode(25, 2));
        method.instructions.add(new MethodInsnNode(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", false));
        method.instructions.add(new InsnNode(191));
        return method;
    }

    private static MethodNode buildDotNetGuidMethod() {
        MethodNode method = new MethodNode(10, DOTNET_GUID_NAME, DOTNET_GUID_DESC, null, null);
        LabelNode okLabel = new LabelNode();
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new InsnNode(190));
        method.instructions.add(new IntInsnNode(16, 16));
        method.instructions.add(new JumpInsnNode(159, okLabel));
        method.instructions.add(new TypeInsnNode(187, "java/lang/IllegalArgumentException"));
        method.instructions.add(new InsnNode(89));
        method.instructions.add(new LdcInsnNode("Expected 16 bytes"));
        method.instructions.add(new MethodInsnNode(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false));
        method.instructions.add(new InsnNode(191));
        method.instructions.add(okLabel);
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new MethodInsnNode(182, "[B", "clone", "()Ljava/lang/Object;", false));
        method.instructions.add(new TypeInsnNode(192, "[B"));
        method.instructions.add(new VarInsnNode(58, 1));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new InsnNode(3));
        method.instructions.add(new InsnNode(6));
        method.instructions.add(new MethodInsnNode(184, HANDSHAKE_HANDLER_INTERNAL, SWAP_NAME, SWAP_DESC, false));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new InsnNode(4));
        method.instructions.add(new InsnNode(5));
        method.instructions.add(new MethodInsnNode(184, HANDSHAKE_HANDLER_INTERNAL, SWAP_NAME, SWAP_DESC, false));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new InsnNode(7));
        method.instructions.add(new InsnNode(8));
        method.instructions.add(new MethodInsnNode(184, HANDSHAKE_HANDLER_INTERNAL, SWAP_NAME, SWAP_DESC, false));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new IntInsnNode(16, 6));
        method.instructions.add(new IntInsnNode(16, 7));
        method.instructions.add(new MethodInsnNode(184, HANDSHAKE_HANDLER_INTERNAL, SWAP_NAME, SWAP_DESC, false));
        method.instructions.add(new VarInsnNode(25, 1));
        method.instructions.add(new InsnNode(176));
        return method;
    }

    private static MethodNode buildSwapMethod() {
        MethodNode method = new MethodNode(10, SWAP_NAME, SWAP_DESC, null, null);
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new VarInsnNode(21, 1));
        method.instructions.add(new InsnNode(51));
        method.instructions.add(new VarInsnNode(54, 3));
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new VarInsnNode(21, 1));
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new VarInsnNode(21, 2));
        method.instructions.add(new InsnNode(51));
        method.instructions.add(new InsnNode(84));
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new VarInsnNode(21, 2));
        method.instructions.add(new VarInsnNode(21, 3));
        method.instructions.add(new InsnNode(84));
        method.instructions.add(new InsnNode(177));
        return method;
    }

    public int priority() {
        return Integer.MIN_VALUE;
    }
}

